'use strict';
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
        var info = gen[key](arg);
        var value = info.value;
    } catch (error) {
        reject(error);
        return;
    }
    if (info.done) {
        resolve(value);
    } else {
        Promise.resolve(value).then(_next, _throw);
    }
}
function _async_to_generator(fn) {
    return function() {
        var self = this, args = arguments;
        return new Promise(function(resolve, reject) {
            var gen = fn.apply(self, args);
            function _next(value) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
            }
            function _throw(err) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
            }
            _next(undefined);
        });
    };
}
let EquityBalanceListener = class EquityBalanceListener {
    /**
   * Returns account id
   */ get accountId() {
        return this._accountId;
    }
    /**
   * Processes an update event when equity or balance changes
   * @param {EquityBalanceData} equityBalanceData equity and balance updated data
   */ onEquityOrBalanceUpdated(equityBalanceData) {
        return _async_to_generator(function*() {
            throw Error('Abstract method onEquityOrBalanceUpdated has no implementation');
        })();
    }
    /**
   * Processes an event which occurs when connection has been established
   */ onConnected() {
        return _async_to_generator(function*() {
            throw Error('Abstract method onConnected has no implementation');
        })();
    }
    /**
   * Processes an event which occurs when connection has been lost
   */ onDisconnected() {
        return _async_to_generator(function*() {
            throw Error('Abstract method onDisconnected has no implementation');
        })();
    }
    /**
   * Processes an error event
   * @param {Error} error error received 
   */ onError(error) {
        return _async_to_generator(function*() {})();
    }
    /**
   * Creates an equity chart listener instance
   * @param {string} accountId account id
   */ constructor(accountId){
        if (!accountId) {
            throw Error('Account id parameter required');
        }
        this._accountId = accountId;
    }
};
/**
 * Equity balance data for account
 * @typedef {Object} EquityBalanceData
 * @property {number} equity account equity
 * @property {number} balance account balance
 */ /**
 * Equity balance event listener for handling a stream of equity and balance updates
 */ export { EquityBalanceListener as default };

//# sourceMappingURL=data:application/json;base64,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