"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return PeriodStatisticsListener;
    }
});
let PeriodStatisticsListener = class PeriodStatisticsListener {
    /**
   * Returns account id
   */ get accountId() {
        return this._accountId;
    }
    /**
   * Returns tracker id
   */ get trackerId() {
        return this._trackerId;
    }
    /**
   * Processes period statistics event which occurs when new period statistics data arrives
   * @param {PeriodStatistics[]} periodStatisticsEvent period statistics event
   */ async onPeriodStatisticsUpdated(periodStatisticsEvent) {
        throw Error("Abstract method onPeriodStatisticsUpdated has no implementation");
    }
    /**
   * Processes period statistics event which occurs when a statistics period ends
   */ async onPeriodStatisticsCompleted() {
        throw Error("Abstract method onPeriodStatisticsCompleted has no implementation");
    }
    /**
   * Processes period statistics event which occurs when the tracker period ends
   */ async onTrackerCompleted() {
        throw Error("Abstract method onTrackerCompleted has no implementation");
    }
    /**
   * Processes an event which occurs when connection has been established
   */ async onConnected() {
        throw Error("Abstract method onConnected has no implementation");
    }
    /**
   * Processes an event which occurs when connection has been lost
   */ async onDisconnected() {
        throw Error("Abstract method onDisconnected has no implementation");
    }
    /**
   * Processes an error event
   * @param {Error} error error received 
   */ async onError(error) {}
    /**
   * Creates a period statistics listener instance
   * @param {string} accountId account id
   * @param {string} trackerId tracker id
   */ constructor(accountId, trackerId){
        if (!accountId) {
            throw Error("Account id parameter required");
        }
        if (!trackerId) {
            throw Error("Tracker id parameter required");
        }
        this._accountId = accountId;
        this._trackerId = trackerId;
    }
};

//# sourceMappingURL=data:application/json;base64,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